#include <iostream>
#include <vector>
#include <string>
#include <map>
#include <algorithm>
using namespace std;

struct TrieNode {
    map<char, TrieNode*> children;
    vector<string> group;
};

void insert(TrieNode* root, const string& number) {
    TrieNode* node = root;
    for (char ch : number) {
        if (!node->children.count(ch)) {
            node->children[ch] = new TrieNode();
        }
        node = node->children[ch];
    }
    node->group.push_back(number);
}

void collectGroups(TrieNode* node, vector<vector<string>>& result) {
    if (!node->group.empty()) {
        result.push_back(node->group);
    }
    for (auto& [ch, child] : node->children) {
        collectGroups(child, result);
    }
}

int main() {
    int n;
    cin >> n;
    vector<string> numbers(n);
    for (int i = 0; i < n; ++i) {
        cin >> numbers[i];
    }

    sort(numbers.begin(), numbers.end(), [](const string& a, const string& b) {
        return a.size() < b.size();
    });

    TrieNode* root = new TrieNode();
    for (const string& num : numbers) {
        insert(root, num);
    }

    vector<vector<string>> groups;
    collectGroups(root, groups);

    cout << groups.size() << "\n";
    for (const auto& group : groups) {
        cout << group.size() << "\n";
        for (const string& num : group) {
            cout << num << " ";
        }
        cout << "\n";
    }

    return 0;
}